package jist.swans.rate;

import java.util.Hashtable;

import jist.swans.mac.MacAddress;
import jist.swans.mac.MacInfo;


/**
 * @author Oliver
 *
 * Singleton class to keep rate info for MAC layers in one place for rate
 * selection module.
 * 
 * This implementation is inherently thread safe. Read the Java World article
 * "Simply Singleton" by David Geary, JavaWorld.com, 04/25/03, if you like.
 */
public class GlobalMacRateInfo
{
  public final static GlobalMacRateInfo INSTANCE = new GlobalMacRateInfo();
  
  private Hashtable m_macInfos;
  
  private GlobalMacRateInfo() {
    // private to defeat external instantiation
    m_macInfos = new Hashtable();
  }
  
  public void setMacInfo(MacAddress address, MacInfo macInfo)
  {
    m_macInfos.put(address, macInfo);
  }
  
  public MacInfo getMacInfo(MacAddress address)
  {
    return (MacInfo) m_macInfos.get(address);
  }
  
  public int[] getBitrates(MacAddress address)
  {
    MacInfo mi = (MacInfo) m_macInfos.get(address);
    if (mi != null)
      return mi.getBitrateSet();
    return null;
  }
  
  public int[] getBasicRates(MacAddress address)
  {
    MacInfo mi = (MacInfo) m_macInfos.get(address);
    if (mi != null)
      return mi.getBasicRateSet();
    return null;
  }
}
