/**
 * 
 */
package jist.swans.rate;

import jist.swans.Constants;

/**
 * This class represents a variable length list of bit-rates and retry values
 * for use with rate control algorithms in high-latency systems.
 * 
 * @author ofriedri
 */
public class MultiRateRetryChain {

  private int size;

  public int[] bitrates;

  public int[] tries;

  public MultiRateRetryChain(int size) {
    this.size = size;
    bitrates = new int[this.size];
    tries = new int[this.size];
    reset();
  }

  /**
   * @return The max number of rate/try pairs of this mrrc object.
   */
  public int getSize() {
    return size;
  }

  public void reset() {
    for (int i = 0; i < size; i++) {
      bitrates[i] = Constants.BANDWIDTH_INVALID;
      tries[i] = 0;
    }
  }

  public String toString() {
    StringBuffer sb = new StringBuffer();
    sb.append("rate:tries --");
    for (int i = 0; i < size; i++)
      sb.append(" (").append(i).append(") ").append(bitrates[i]/Constants
          .BANDWIDTH_1Mbps).append(":").append(tries[i]);
    return sb.toString();
  }
}
