/*
 * ColorProfileBezier.java
 *
 * Created on June 6, 2007, 1:43 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.colorprofiles;

/**
 *
 * @author Oliver
 */

import sidnet.core.gui.*;
import sidnet.core.interfaces.ColorProfile;
import java.awt.Color;
/**
 *
 * @author Oliviu Ghica
 */
public class ColorProfileBezier extends ColorProfile{
    // Events list - lowest number - highest priority 
    // public static final int DEAD       = 0;   // pre-defined in the ColorProfile
    // public static final int SELECTED   = 1;   // pre-defined in the ColorProfile
    public static final int DATA       = 2;
    public static final int TRANSMIT   = 3;
    public static final int RECEIVE    = 4;
    public static final int SINK       = 5;
    public static final int SOURCE     = 6;
    public static final int HEAD       = 7;
    public static final int RESPONDENT = 8;
    public static final int SLEEP      = 9;
    public static final int SENSE      = 10;
    public static final int DEFAULT    = 11; // !!!! default must be declared, and it must be the last one, DEFAULT = colorNum - 1 !!!!!
    
    private static final int colorNum  = 12;
    
    /**
     * Creates a new instance of ColorProfileBezier
     */
    public ColorProfileBezier() 
    {
        super(colorNum);
        
        // null means transparent, or, I don't care of this color - you'll see the "next" active color looking through the highest priority to the lowest
        innerColorList[DATA]        = Color.red;           outerColorList[DATA]       = null;
        innerColorList[TRANSMIT]    = Color.red;           outerColorList[TRANSMIT]   = Color.red;
        innerColorList[RECEIVE]     = Color.green;         outerColorList[RECEIVE]    = null;
        innerColorList[SINK]        = Color.red;           outerColorList[SINK]       = null;
        innerColorList[SOURCE]      = Color.yellow;        outerColorList[SOURCE]     = null;     
        innerColorList[RESPONDENT]  = Color.magenta;       outerColorList[RESPONDENT] = Color.cyan;
        innerColorList[SENSE]       = Color.blue;          outerColorList[SENSE]      = null;
        innerColorList[SLEEP]       = Color.gray;          outerColorList[SLEEP]      = null;
        innerColorList[DEFAULT]     = Color.white;         outerColorList[DEFAULT]    = Color.black;
        
        // Timings
        colorLifeTime[DEFAULT] = FOREVER;
    }
    
  
}
