/*
 * ColorProfileMultiTree.java
 *
 * Created on March 20, 2007, 12:12 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.colorprofiles;

/**
 *
 * @author Oliver
 */

import sidnet.core.gui.*;
import sidnet.core.interfaces.ColorProfile;
import java.awt.Color;


public class ColorProfileMultiTree extends ColorProfile{
    // Events list - lowest number - highest priority 
    // public static final int DEAD       = 0;   // pre-defined in the ColorProfile
    // public static final int SELECTED   = 1;   // pre-defined in the ColorProfile
    public static final int DATA       = 2;
    public static final int TRANSMIT   = 3;
    public static final int RECEIVE    = 4;
    public static final int SLEEP      = 5;
    public static final int SINK       = 6;
    public static final int SENSE      = 7;
    public static final int DEFAULT    = 8; // !!!! default must be declared, and it must be the last one, DEFAULT = colorNum - 1 !!!!!
    
    private static final int colorNum  = 9;
  
    /**
     * Constructor function in which you must define the assignment of colors to the array
     */
    public ColorProfileMultiTree() {
        super(colorNum);
        
        // null means transparent, or, I don't care of this color
        innerColorList[DATA]     = Color.red;           outerColorList[DATA]     = null;
        innerColorList[TRANSMIT] = null;                outerColorList[TRANSMIT] = Color.red;
        innerColorList[RECEIVE]  = Color.green;         outerColorList[RECEIVE]  = null;
        innerColorList[SLEEP]    = Color.gray;          outerColorList[SLEEP]    = null;
        innerColorList[SINK]     = Color.red;           outerColorList[SINK]     = null;
        innerColorList[SENSE]    = Color.blue;          outerColorList[SENSE]    = null;
        innerColorList[DEFAULT]  = Color.white;         outerColorList[DEFAULT]  = Color.black;
    }  
}
