/*
 * PopupMenu.java
 *
 * Created on May 23, 2006, 11:07 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.core.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

/**
 *
 * @author Oliviu Ghica
 */
public class MyPopupMenu implements ActionListener{
    public static final int MAX_MENUS = 15;
    public static final int NONE      = -1;
    
    private static String[] OnText;
    private static String[] OffText;
    private String[] Data;
    private static int menuItemCount;
    private static int showDataIndex;
    private JPopupMenu mainPopupMenu;
    private static JMenuItem[] menuItem;
    
    /** Creates a new instance of PopupMenu */
    public MyPopupMenu() {
        mainPopupMenu = new JPopupMenu();
        Data          = new String[MAX_MENUS];
        OnText        = new String[MAX_MENUS];
        OffText       = new String[MAX_MENUS];
        menuItem      = new JMenuItem[MAX_MENUS];
        menuItemCount = 0;
        showDataIndex = NONE;
    }
    
    // Returns a handle to the menu item
    public int addMenuItem(String OnText, String OffText)
    {
        this.OnText[menuItemCount]  = OnText;
        this.OffText[menuItemCount] = OffText;
        menuItem[menuItemCount] = new JMenuItem(OnText);
        menuItem[menuItemCount].addActionListener(this);
        mainPopupMenu.add(menuItem[menuItemCount]);
        Data[menuItemCount] = "";
        
        System.out.println("Menu item added");
        
        menuItemCount++;
        return menuItemCount - 1;
    }
    
    public void justAdd(JMenuItem newMenuItem)
    {
        mainPopupMenu.add(newMenuItem);
    }
    
    public void show(JPanel panel, int x, int y)
    {     
        mainPopupMenu.show(panel, x, y);
    }
    
    public JMenuItem getComponent(int compID)
    {
        return (JMenuItem)mainPopupMenu.getComponent(compID);
    }
    
    public void addSeparator()
    {
        mainPopupMenu.addSeparator();
    }
    
    public String getData()
    {
        if (showDataIndex != NONE)
            return Data[showDataIndex];
        else
            return "";
    }
    
    public void setData(String data, int handle)
    {
        if (handle < 0 || handle >= menuItemCount)
        {
            System.out.println("[ERROR: PopupMenu] - invalid menu handle");
            return;
        }
        
        Data[handle] = data;
    }
    
    public JPopupMenu getPopupMenu()
    {
        return mainPopupMenu;
    }
    
    // Actions on the menu
    public void turnOnExcept(int handle)
    {
        for (int i = 0; i < menuItemCount; i++)
        {
            if (i != handle)
                menuItem[i].setText(OnText[i]);
        }
    }
    
    public void turnOffExcept(int handle)
    {
        for (int i = 0; i < menuItemCount; i++)
        {
            if (i != handle)
                menuItem[i].setText(OffText[i]);
        }
    }
    
    public void actionPerformed(ActionEvent e) { 
        for (int i = 0 ; i < menuItemCount; i++)
        {
            if (e.getActionCommand() == OnText[i])
            {
                menuItem[i].setText(OffText[i]);
                turnOnExcept(i);
                showDataIndex = i;
            }
            if (e.getActionCommand() == OffText[i])
            {
                menuItem[i].setText(OnText[i]);
                turnOffExcept(i);
                showDataIndex = NONE;
            }
        }
    }
}
