/*
 * FileUtils.java
 *
 * Created on April 8, 2008, 10:44 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.core.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;

/**
 *
 * @author Oliver
 */
 public class FileUtils
 {
     /*
      * Check to see if a file is empty or not 
      */
     public static boolean isEmpty(File file)
     {
         BufferedReader input = null;
         try{
             input = new BufferedReader(new FileReader(file));
         } catch(FileNotFoundException e){e.printStackTrace();System.exit(1);};
         
         String nextLine = "";
         try{
            nextLine = input.readLine();
            if (input != null)
                input.close();
         }catch(IOException ioe){ioe.printStackTrace(); System.exit(1);};
         
         if (nextLine != null && nextLine.length() > 0)
             return false;
         else
             return true;
     }
      
      /**
       * Directory is valid if it exists, does not represent a file, and can be read.
       */
      public static void validateDirectory (File dir) throws FileNotFoundException 
      {
          if (dir == null) 
          {
              throw new IllegalArgumentException("Directory should not be null.");
          }
          if (!dir.exists()) 
          {
              throw new FileNotFoundException("Directory does not exist: " + dir);
          }
          if (!dir.isDirectory()) 
          {
              throw new IllegalArgumentException("Is not a directory: " + dir);
          }
          if (!dir.canRead()) 
          {
              throw new IllegalArgumentException("Directory cannot be read: " + dir);
          }
      }
          
     public static void deleteFilesWithPrefix( String dirPath, String filenamePrefix ) 
    {
        PrefixFilter filter = new PrefixFilter(filenamePrefix);
        File dir = new File(dirPath);

        String[] list = dir.list(filter);
        File file;
        
        System.out.println(">> Target = " + dirPath);
        System.out.println(">> Look for = " + filenamePrefix);
        System.out.println(">> Found " + list.length + " deletable files.");
        
        if (list.length == 0) return;

        for (int i = 0; i < list.length; i++)
        {
           file = new File(dirPath, list[i]);
           try
           {
               new FileWriter(file).close();
           }
           catch(Exception e){e.printStackTrace();};
           boolean isdeleted =   file.delete();
           System.out.print(file);
           if (isdeleted)
                System.out.println( "  deleted!");
           else
               System.out.println(" could not be deleted");
       }
     }
        
       public static void appendToFilesWithPrefix(String dirPath, String filenamePrefix, String text)
       {
            System.out.println(" +++++ Commit " + text + " to " + filenamePrefix);
           
            PrefixFilter filter = new PrefixFilter(filenamePrefix);
            File dir = new File(dirPath);

            
            String[] list = dir.list(filter);
            if (list.length == 0)
                return;
            
            System.out.println(" +++++ Commit " + text + " to " + list[0]);
            
            FileWriter fileWriter = null;
            BufferedWriter bw = null;
            
            try{
                File file = new File(dirPath, list[0]); // there should be normally only one file of this kind
                fileWriter = new FileWriter(file, true); // true- append mode
                bw = new BufferedWriter(fileWriter);
                bw.write(text);
                bw.newLine();
                bw.flush();
                bw.close();
                fileWriter.close();
            } catch (IOException ioe) {
                ioe.printStackTrace();
            } finally {                       // always close the file
                if (bw != null) try {
                   bw.close();
                   fileWriter.close();
                } catch (IOException ioe2) {
                   // just ignore it
                }
            } // end try/catch/finally
       }
       
   public static String[] getFileList(String dirPath, FilenameFilter optionalFilenameFilter)
   {
          File dir = new File(dirPath);

          String[] list = null;
          if (optionalFilenameFilter != null)
              list = dir.list(optionalFilenameFilter);
          else
              list = dir.list();
          
          return null;
   }
     

   public static class PrefixFilter implements FilenameFilter 
   {
         private String prefix;
         public PrefixFilter( String prefix )
         {
             this.prefix = prefix;             
         }
         public boolean accept(File dir, String name) 
         {
             return (name.startsWith(prefix));
         }
   }
   
   public static class SufixFilter implements FilenameFilter 
   {
         private String sufix;
         public SufixFilter( String sufix )
         {
             this.sufix = sufix;             
         }
         public boolean accept(File dir, String name) 
         {
             return (name.endsWith(sufix));
         }
   }
 }
