/*
 * DeadEndList.java
 *
 * Created on November 3, 2005, 5:41 PM
 */

package sidnet.core.misc;

/**
 *
 * @author  Oliviu Ghica
 */

import jist.swans.net.NetAddress;


import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import jist.runtime.JistAPI;
import jist.swans.mac.MacAddress;


public class NodesList{

    private HashMap list = null;
    private int size;
    
    
    /** Creates a new instance of DeadEndList */
    public NodesList() {
        list   = new HashMap();
        size = 0;
    }
    
    public void add(NetAddress ip, NodeEntry entry)
    {
        /* Check to see if the object already exist */
        NodeEntry n = (NodeEntry)list.get(ip);
        if(n==null)
        {
            list.put(ip, entry);
            size ++;
        }
    }
    
    public void add(NodeEntry n)
    {
        if (n.ip != null)
            add(n.ip, n);
    }
    
    public void add(NetAddress ip)
    {
        add(ip, new NodeEntry(null, ip, null)); 
    }
    
    public void remove(NetAddress ip)
    {
        Iterator it = list.values().iterator();
        while(it.hasNext()) 
        {
            NodeEntry n = (NodeEntry)it.next();
     
            if (n.ip.equals(ip))
            {
                it.remove();
                size --;
            }
        }
    }
    
    public void remove(NodeEntry n)
    {
        if (n.ip != null)
            remove(n.ip);
    }
    
    public void printList()
    {
        System.out.println("NodeList : ");
        Iterator it = list.values().iterator();
        while(it.hasNext()) 
        {
            NodeEntry n = (NodeEntry)it.next();
            System.out.println("        IP: " + n.ip + "        MAC: " + n.mac + "        Location: (" + n.getNCS_Location2D().getX() + ", " + n.getNCS_Location2D().getY() + ")");
        }
    }
    
    public boolean exist(NetAddress ip)
    {
        Iterator it = list.values().iterator();
        while(it.hasNext()) 
        {
            NodeEntry n = (NodeEntry)it.next();
     
            if (n.ip.equals(ip))
                return true;  
        }
        return false;
    }
    
    public boolean exist(MacAddress mac)
    {
        Iterator it = list.values().iterator();
        while(it.hasNext()) 
        {
            NodeEntry n = (NodeEntry)it.next();
     
            if (n.mac.equals(mac))
                return true;  
        }
        return false;
    }
    
    public NodeEntry get(NetAddress ip)
    {
        if (exist(ip))
            return (NodeEntry)list.get(ip);
        else
            return null;
    }
    
    public NodeEntry getElementAt(int index)
    {
        NodeEntry n = null;
        
        Iterator it = list.values().iterator();
        while(it.hasNext() && index >= 0) 
        {
            n = (NodeEntry)it.next();
            index--;
        }
        return n;
    }
    
    public LinkedList<NodeEntry> getAsLinkedList()
    {
        LinkedList<NodeEntry> neighboursList = new LinkedList<NodeEntry>();
        
        Iterator it = list.values().iterator();
        while(it.hasNext()) 
            neighboursList.add((NodeEntry)it.next());
        
        return neighboursList;
    }
    
    public int size()
    {
        return size;
    }
    
    public double getFurthestNodeDistanceNCS(NCS_Location2D fromLocation)
    {
        LinkedList<NodeEntry> nodeList = getAsLinkedList();
        double max = 0;
        for(NodeEntry entry:nodeList)
        {
            if (max < fromLocation.distanceTo(entry.getNCS_Location2D()))
                max = fromLocation.distanceTo(entry.getNCS_Location2D());
        }
        return max;
    }
}
