/*
 * XMLUtils.java
 *
 * Created on April 4, 2008, 4:06 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.core.misc;

import sidnet.core.misc.*;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import jist.runtime.JistAPI;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 *
 * @author Oliver
 */
public class XMLUtils implements JistAPI.DoNotRewrite
{   
    static final MyErrorHandler myErrorHandler = new MyErrorHandler();
    public static boolean xmlValidation(File xmlFile) 
    {        
        if (xmlFile == null)
            return false;
        try {
            // Create a new XML parser
            XMLReader reader = XMLReaderFactory.createXMLReader();
            // Request validation
            reader.setFeature("http://xml.org/sax/features/validation",true);
            reader.setFeature("http://apache.org/xml/features/validation/schema",true);
            reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking",true);
            reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation","deploymentSchema.xsd");
            //reader.setFeature("file:\\D:\\My Documents\\deploymentSchema.xsd", true);
            // Register the error handler
            reader.setErrorHandler(myErrorHandler);
            // Parse the file as the first argument on the command-line
            System.out.println("parse file: " + xmlFile.getAbsolutePath());
            //System.out.println("Schema file:" + reader.)
            reader.parse(xmlFile.getAbsolutePath());
        } catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            //e.printStackTrace();
            return false;
        }
        return true;
    }
    
    public static Object xmlParser(String targetClassPackageName, File xmlFile)
    {
        Object pojo = null;
        
        try{
            JAXBContext context = JAXBContext.newInstance(targetClassPackageName) ;

            Unmarshaller unmarshaller = context.createUnmarshaller() ;

            pojo = unmarshaller.unmarshal(xmlFile);
        }
        catch (Exception e){e.printStackTrace(); } ;
        
        return pojo;
    }


  
}
    



 class MyErrorHandler implements ErrorHandler {
    public void warning(SAXParseException exception) throws SAXException {
        // Bring things to a crashing halt
        System.out.println("**Parsing Warning**" +
                           "  Line:    " + 
                              exception.getLineNumber() + "" +
                           "  URI:     " + 
                              exception.getSystemId() + "" +
                           "  Message: " + 
                              exception.getMessage());        
        throw new SAXException("Warning encountered");
    }
    public void error(SAXParseException exception) throws SAXException {
        // Bring things to a crashing halt
        System.out.println("**Parsing Error**" +
                           "  Line:    " + 
                              exception.getLineNumber() + "" +
                           "  URI:     " + 
                              exception.getSystemId() + "" +
                           "  Message: " + 
                              exception.getMessage());        
        throw new SAXException("Error encountered");
    }
    public void fatalError(SAXParseException exception) throws SAXException {
        // Bring things to a crashing halt
        System.out.println("**Parsing Fatal Error**" +
                           "  Line:    " + 
                              exception.getLineNumber() + "" +
                           "  URI:     " + 
                              exception.getSystemId() + "" +
                           "  Message: " + 
                              exception.getMessage());        
        throw new SAXException("Fatal Error encountered");
    }
}