package sidnet.jist.swans;

//////////////////////////////////////////////////
//JIST (Java In Simulation Time) Project
//Timestamp: <NetInterface.java Tue 2004/04/06 11:32:40 barr pompom.cs.cornell.edu>
//

//Copyright (C) 2004 by Cornell University
//All rights reserved.
//Refer to LICENSE for terms and conditions of use.

import jist.swans.mac.MacAddress;
import jist.swans.misc.Message;
import jist.swans.net.NetAddress;
import jist.swans.net.NetMessage;

import jist.runtime.JistAPI;

/**
* Defines the interface of all Network layer entity implementations.
*
* @author Rimon Barr &lt;barr+jist@cs.cornell.edu&gt;
* @version $Id: NetInterface.java,v 1.18 2004/04/06 16:07:49 barr Exp $
* @since SWANS1.0
*/

public interface NetInterface extends JistAPI.Proxiable, jist.swans.net.NetInterface
{
  public static interface NetHandler
  {
    /**
     * Receive a message from network layer.
     *
     * @param msg message received
     * @param src source network address
     * @param lastHop source link address
     * @param macId incoming interface
     * @param dst destination network address
     * @param priority packet priority
     * @param ttl packet time-to-live
     */
    void receive(Message msg, NetAddress src, MacAddress lastHop, 
        byte macId, NetAddress dst, byte priority, byte ttl);
    
    /**
     * Send a message through the routing protocol
     *
     * @param NetMessage outgoing message
     */
    void send(NetMessage msg); // OLIVER: 01-17-2008. Adding support for multiple routing protocols.
  } // interface: NetHandler 
} // interface: NetHandler

