package sidnet.jist.swans;

//////////////////////////////////////////////////
//JIST (Java In Simulation Time) Project
//Timestamp: <RouteInterface.java Tue 2004/04/06 11:35:24 barr pompom.cs.cornell.edu>
//

//Copyright (C) 2004 by Cornell University
//All rights reserved.
//Refer to LICENSE for terms and conditions of use.


import jist.swans.mac.MacAddress;
import jist.swans.net.NetAddress;
import jist.swans.net.NetMessage;
import jist.swans.net.NetInterface;
import jist.swans.misc.Message;
import jist.swans.misc.Timer;
import jist.swans.misc.Protocol;

import jist.runtime.JistAPI;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;

/**
* Defines the interface of all Routing implementations and the Route entity.
*
* @author Rimon Barr &lt;barr+jist@cs.cornell.edu&gt;
* @version $Id: RouteInterface.java,v 1.48 2004/04/06 16:07:50 barr Exp $
* @since SWANS1.0
*/
public interface RouteInterface extends NetInterface.NetHandler, JistAPI.Proxiable, jist.swans.route.RouteInterface
{

 void netQueueFull(Message msg, MacAddress nextHopMac);
 
//////////////////////////////////////////////////
// Heartbeat Routing Protocol 
//

/**
* NWU routing entity interface.
*/
public static interface HeartbeatProtocol extends RouteInterface, Protocol
{
 
   public void wakeAndBeat(long sleepPeriod, boolean wakeAndBeatStarted);
   
}// (HeartbeatProtocol) protocol

//////////////////////////////////////////////////
// Bezier Routing Protocol 
//

/**
* NWU routing entity interface.
*/
public static interface BezierRouting extends RouteInterface, Protocol
{
 
   //void setupBezier(Bezier bezierCurveLeft, Bezier bezierCurveRight);
   
}// (Bezier Routing Protocol) protocol


/**
* NWU routing entity interface.
*/
public static interface GenericRouting extends RouteInterface, Protocol
{
   
}// (GenericRouting) protocol

/**
* NWU routing entity interface.
*/
public static interface MultiTreeRouting extends RouteInterface, Protocol
{
   
}// (MultiTreeRouting) protocol


//////////////////////////////////////////////////
// ECGRID Routing Protocol 
//

/**
* NWU routing entity interface.
*/
public static interface ECGRIDRouting extends RouteInterface, Protocol
{
  void start();
}// (ECGRID Routing Protocol) protocol


//////////////////////////////////////////////////
// Shortest-Path Localized Routing Protocol 
//

/**
* NWU routing entity interface.
*/
public static interface ShortestPathRouting extends RouteInterface, Protocol
{
   
}// (Shortest-Path Routing Protocol) protocol


//////////////////////////////////////////////////
// Random-Path Localized Routing Protocol 
//

/**
* NWU routing entity interface.
*/
public static interface RandomPathRouting extends RouteInterface, Protocol
{
   
}// (Random-Path Routing Protocol) protocol


} // class: RouteInterface

