/*
 * MessageDataP2P.java
 *
 * Created on December 18, 2007, 3:58 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.messages;

import jist.swans.misc.Message;
import sidnet.core.misc.Query;
import sidnet.core.misc.Region;

/**
 *
 * @author Oliver
 */
/**
   * DataP2P packet.
   */
  public class MessageDataP2P implements Message
  {
    public final Query query;
    public final double dataValue;
    public final int queryId;
    public final long sequenceNumber;
    
    public MessageDataP2P(Query query, int queryId)
    {
        this.query     = query;
        dataValue      = -1;
        this.queryId        = queryId;
        sequenceNumber = -1;
    }
    
    public MessageDataP2P(double dataValue)
    {
        query = null;
        this.dataValue = dataValue;
        queryId        = -1;
        sequenceNumber = -1;
    }
    
    public MessageDataP2P(double dataValue, int queryId, long sequenceNumber)
    {
        query = null;
        this.dataValue = dataValue;
        this.queryId   = queryId;
        this.sequenceNumber = sequenceNumber;
    }
    
    /** {@inheritDoc} */
    public int getSize() 
    { 
      int size = 0;
      if (query != null)
          size += query.getAsMessageSize();
      size += 4; // double dataValue;
      size += 2; // double sequenceNumber;
      size += 4; // double sequenceNumber;
  
      return size;
    }
    /** {@inheritDoc} */
    public void getBytes(byte[] b, int offset)
   {
      throw new RuntimeException("not implemented");
    }
  } // class: MessageP2P
