/*
 * NZMessage.java
 *
 * Created on November 24, 2007, 1:16 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.messages;

import jist.swans.net.NetAddress; 
import jist.swans.misc.Message;

import sidnet.core.misc.Query;
import sidnet.core.misc.Location2D;


/**
 *
 * @author nikolay
 */
public class NZMessage implements Message {
    public int queryId;
    public long s_seq;      // sequence number to filter duplicates
    public long timeSent;
    private Location2D sourceLoc = null;
    private Location2D[] path = null;
    
    private Query query;
    
    private Message payload;
    
    
    
     public NZMessage(int queryId, long s_seq, long timeSent, Message payload) {
        int tX = 0;
        this.queryId     = queryId;
        this.s_seq       = s_seq;
        this.timeSent    = timeSent;
        this.payload = payload;
    }
     
    public Location2D[] getPath()
    {
        return path;
    }
    
    public void setPath(Location2D[] path)
    {
        this.path = path;
    }
    
    public Message getPayload(){ return payload; }
    
    public Location2D getSourceLocation(){ return sourceLoc;};
    public void setSourceLocation(Location2D loc){ sourceLoc = loc;};
    
    public Query getQuery() { return query; }
    public void setQuery(Query newQuery) 
    { 
        query = newQuery; 
    }
        
    /** {@inheritDoc} */
    public int getSize() 
    { 
        int size = 0;
        size += 4;  // long s_seq;
        size += 4;  // long timeSent
        if (payload != null)
            size += payload.getSize();
        if (query != null)
            size += query.getAsMessageSize();
        if (sourceLoc != null)
            size += 4;
        if (path != null)
            size += 4 * path.length;
        //System.out.println("NZmessage has size = " + size);
        return size;
    }
    
    /** {@inheritDoc} */
    public void getBytes(byte[] b, int offset)
    {
        throw new RuntimeException("not implemented");
    }
   
    public NZMessage copy () {
        NZMessage newMsg = new NZMessage();
        newMsg.s_seq = s_seq;      // sequence number to filter duplicates
        newMsg.timeSent = timeSent;
    
        newMsg.payload = payload;
        newMsg.sourceLoc = sourceLoc;
        if (path != null)
        {
            newMsg.path = new Location2D[path.length];
            for (int i = 0; i < path.length; i++)
                newMsg.path[i] = path[i];
        }
        else
            newMsg.path = null;

        newMsg.query = query;
        
        return newMsg;
    }
    
    /** Creates a new instance of NZMessage */
    public NZMessage() {
    }
    
}
