/*
 * EnergyManagementImpl.java
 *
 * Created on March 20, 2008, 10:41 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.models.energy.energyconsumption;

import sidnet.models.energy.batteries.Battery;
import sidnet.models.energy.batteries.BatteryControl;

/**
 *
 * @author Oliver
 */
public class EnergyManagementImpl implements EnergyManagement
{
    private EnergyModel energyModel;
    private Battery battery;
    private Battery stubBattery;
    
    /** Creates a new instance of EnergyManagementImpl */
    public EnergyManagementImpl(EnergyModel energyModel, Battery battery)
    {
        this.energyModel = energyModel;
        this.battery     = battery;
        stubBattery = new StubBattery(battery);
    }
    
    public Battery getBattery()
    {
        return stubBattery;
    }
    
    public EnergyModel getEnergyModel()
    {
        return energyModel;
    }
    
    public class StubBattery implements Battery, BatteryControl
    {
        Battery battery;
        
        public StubBattery (Battery battery)
        {
            this.battery = battery;
        }
        
        /* Get Energy Level
         * <p>
         * @return double      the level of the battery [mJ]
         *
         */
        public double getEnergyLevel()
        {
            if (battery.getEnergyLevel() == battery.INF)
                return battery.getCapacity();
            double energyLostDueToActivity = battery.getCapacity() - ((EnergyModelAccessible)energyModel).getEnergyLevel(); 
            double remainingEnergy =  battery.getEnergyLevel() - energyLostDueToActivity;
            if (remainingEnergy < 0)
                remainingEnergy = 0;
            return remainingEnergy;
        }

        /* Get Energy Level as a percentage
         * <p>
         * @return double     the energy level of the battery [%]
         *
         */
        public double getPercentageEnergyLevel()
        {
             double remainingEnergy = getEnergyLevel();
                
            if (remainingEnergy != INF)
                return (remainingEnergy * 100 / battery.getCapacity());
            else
                return 100; /* % */
        }

        /* Get the capacity of the battery
         * <p>
         * @return double     the capacity of the battery [mJ]
         */
        public double getCapacity()
        {
            return battery.getCapacity();
        }

        /* 
         * Deplete a battery. A battery that has infinite capacity cannot be depleted.
         */
        public void deplete()
        {
             ((BatteryControl)battery).deplete();
        }
        
        public void depleteAmount(double amount)
        {
            // battery.depleteAmount(); NOT USED. NOT DESINGED TO BE USED THIS WAY.
        }
        

        /* 
         * Recharge a battery to the designated level [mAh]s. A battery that has infinite capacity cannot be recharged.
         */
        public void recharge(double amount)
        {
            ((BatteryControl)battery).recharge(amount);
        }

         /*
         * Returns the specified voltage of this battery
         */
        public double getVoltage()
        {
            return battery.getVoltage();
        }
    }
    
}
