/*
 * Mob.java
 *
 * Created on November 7, 2007, 3:31 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.models.senseable.mob;

import java.util.LinkedList;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author Oliver
 */

@XmlRootElement
public class Mob {
    
    public String mobProfileName;
    
    // dimensions
    public FieldDimensions fieldDimensions;
    
    public int radiance;
    
    public String timeUnit;
    
    public Path path;
    
    /** Creates a new instance of Mob */
    public Mob() {
    }
    
    public static class FieldDimensions
    {
        public int length;
        public int width;
    }
    
    public static class LocationInTime
    {
        public long timeStamp;
        public int xCoord;
        public int yCoord;
    }
    
    public static class Path
    {
        public LinkedList<LocationInTime> locationInTime;
    }
    
    public void printComponents()
    {
        System.out.println("mobProfileName: " + mobProfileName);
        System.out.println("fieldDimensions:");
        System.out.println("\tlength: " + fieldDimensions.length);
        System.out.println("\twidth: " + fieldDimensions.width);
        System.out.println("radiance: " + radiance);
        System.out.println("timeUnits: " + timeUnit);
        System.out.println("path:");
        for(LocationInTime lit: path.locationInTime)
        {
            System.out.println("\tlocationInTime: ");
            System.out.println("\t\ttimeStamp: " + lit.timeStamp);
            System.out.println("\t\txCoord: " + lit.xCoord);
            System.out.println("\t\tyCoord: " + lit.yCoord);
        }
    }
}
