/*
 * MovingObjectsPanel.java
 *
 * Created on November 21, 2007, 2:29 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.models.senseable.mob;

import sidnet.core.interfaces.SIDnetDrawableInterface;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import sidnet.core.misc.Location2D;
import sidnet.core.misc.LocationContext;
import sidnet.core.misc.NCS_Location2D;

/**
 *
 * @author Oliver
 */
public class MovingObjectsPanel extends JPanel implements SIDnetDrawableInterface{
    
    private List<Location2D> mobs;
    
    /** Since this is a GUI, it is important to know the dimension information of the area in which we draw to be able to convert location information from NCS */
    private LocationContext locationContext;
    
    /** Creates a new instance of MovingObjectsPanel */
    public MovingObjectsPanel() {
        mobs = new LinkedList<Location2D>();
    }
    
    public void configureGUI(JPanel hostPanel)
    {
         if (hostPanel == null)
             return;
         
        this.setOpaque(false);
        this.setBackground(Color.black);
        hostPanel.setLocation(0,0);
        hostPanel.add(this);

        this.setBounds(hostPanel.getBounds());

        this.setSize(hostPanel.getSize());

        /* We choose to enable this by default */
        this.setVisible(false); 

         if (hostPanel == null)
             return;
         
       
        locationContext = new LocationContext(hostPanel.getWidth(), hostPanel.getHeight());
    }
    
    public void repaintGUI()
    {
        // TODO;
        repaint();
        
    }
    
    public void setVisibleGUI(boolean visibility)
    {
        this.setVisible(visibility);
    }
    
    public synchronized void updateMobs(List<NCS_Location2D> mobs)
    {
        if (mobs == null)
            return;
        this.mobs.clear();
        for (NCS_Location2D loc: mobs)
        {
            this.mobs.add(loc.fromNCS(locationContext));
        }
    }
    
       public synchronized void paintComponent(Graphics g) {
          Graphics2D g2d = (Graphics2D)g;
          
          g2d.setColor(Color.RED);
          try{
            for (Location2D loc:mobs)
                  g2d.fillRect(loc.getX(), loc.getY(), 20, 20);
          }
          catch(Exception e){} 
        
       }
    
       protected void clear(Graphics g) {
        //super.paintComponent(g);
    }    
    
}
