/*
 * Phy802_15_4Timer.java
 *
 * Created on July 23, 2008, 11:50 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.stack.mac.ieee802_15_4;

import jist.runtime.JistAPI;
import jist.swans.Constants;
import sidnet.core.misc.TimerInterface;

/**
 *
 * @author Oliver
 * Java adaptation after NS-2 C++ implementation
 */ 
/*
 * Copyright (c) 2003-2004 Samsung Advanced Institute of Technology and
 * The City University of New York. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Joint Lab of Samsung 
 *      Advanced Institute of Technology and The City University of New York.
 * 4. Neither the name of Samsung Advanced Institute of Technology nor of 
 *    The City University of New York may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE JOINT LAB OF SAMSUNG ADVANCED INSTITUTE
 * OF TECHNOLOGY AND THE CITY UNIVERSITY OF NEW YORK ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN 
 * NO EVENT SHALL SAMSUNG ADVANCED INSTITUTE OR THE CITY UNIVERSITY OF NEW YORK 
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
public class Phy802_15_4Timer implements TimerInterface
{
    protected boolean started;
    protected boolean busy;
    protected boolean paused;
    protected boolean canceled;
    protected boolean terminated;
    protected double stime = 0.0;		//start time
    protected double wtime = 0.0;		//waiting time
    protected double lastMomentOfPause = 0.0;
    protected double totalPauseTime = 0.0;
    protected int id = 0; // for debugging purposes only
    
    // ------------------------------------
    protected Phy802_15_4Impl phy;
    protected int type;
    protected boolean active;
    MacMessage_802_15_4 p = null;
    
    private TimerInterface self = (TimerInterface)JistAPI.proxy(this, TimerInterface.class);
    
    private String getType()
    {
        switch(type)
        {
            case 1: return "CCAH"; 
            case 2: return "EDHT"; 
            case 3: return "TRXHT"; 
            case 4: return "phyRecvOverH"; 
            case 5: return "phySendOverH";
            default: return "INVALID"; 
        }
    }
        
    public Phy802_15_4Timer(Phy802_15_4Impl p, int tp, int id)
    {
        //super();
        phy = p;
        type = tp;
        active = false;
        this.id = id;
    }
    
    public void startTimer(double wtime, MacMessage_802_15_4 p)
    {
        if (Def.DEBUG802_15_4_timer)
            System.out.println("["+JistAPI.getTime()+"][" + id + "][Phy802_15_4Timer." + getType() + ".startTimer( _ , _ )]");
        
	active = true;
        this.p = p;
        this.startTimer(wtime);
	//nullEvent.uid_ = 0;
    }
    
    public void cancel()
    {
        this.cancelTimer();
	active = false;
    }
    
    public void timeout()
    {
        //timeout();
        if (Def.DEBUG802_15_4_timer)
            System.out.println("["+JistAPI.getTime()+"][#" + id + "][Phy802_15_4Timer." + getType() + ".timeout()]");
        
        active = false;
	if (type == Phy802_15_4Impl.phyCCAHType)
		phy.CCAHandler();
	else if(type == Phy802_15_4Impl.phyEDHType)
		phy.EDHandler();
	else if(type == Phy802_15_4Impl.phyTRXHType)
		phy.TRXHandler();
	else if(type == Phy802_15_4Impl.phyRecvOverHType)
		phy.recvOverHandler(/*(MacMessage_802_15_4 )e ??? */ p);
	else if(type == Phy802_15_4Impl.phySendOverHType)
		phy.sendOverHandler();
	else	
		assert(false);
        
        terminated = true;
    }
    // ------------------------------------
    
    public void resetTimer()
    {
        busy       = false;
        paused     = false;
        stime = 0;
        wtime = 0;
    }
    
    /**
     * Handle timer expiration.
     */
    /*public void timeout()
    {
        // user code to be executed at timer expiration
    }*/
    
    /**
     * Start timer
     */
    public void startTimer(double time)
    {
        assert(!busy && !started);
	busy = true;
	stime = JistAPI.getTime();
	wtime = time;
	assert(wtime >= 0);
	//s.schedule(this, /* & */event, wtime);
        if (Def.DEBUG802_15_4_timer)
        {
            System.out.println("wtime = " + wtime);
            System.out.println("Constants.SECOND = " + Constants.SECOND);
            System.out.println("wtime * Constants.SECOND = " + (wtime * Constants.SECOND));
            System.out.println("[" + JistAPI.getTime() + "][" + id + "][Phy802_15_4Timer." + getType() + ".startTimer()]. Timer scheduled to expire at " + (long)(JistAPI.getTime() + wtime * Constants.SECOND) + " (wtime = " + wtime);
        }
        JistAPI.sleep((long)(wtime * Constants.SECOND));
        if (!canceled /* && !terminated*/ && !paused) //???
        {
            self.timeout();
        }
        else
            if (Def.DEBUG802_15_4_timer)
                System.out.println("["+JistAPI.getTime()+"][#" + id + "][Phy802_15_4Timer." + getType() + ".startTimer( _ ): Timer was canceled, terminated or paused]");
    }
    
    /**
     * Cancel timer
     */ 
    private void cancelTimer()
    {
        assert(started);
        canceled = true;
    }
    
    public boolean canceled()
    {
        return canceled;
    }
    
    public boolean busy()
    {
        return busy;
    }
    
    public boolean paused()
    {
        return paused;
    }
    
    public double expire()
    {
        return ((double)JistAPI.getTime())/Constants.SECOND - stime - totalPauseTime > wtime ? 0 : wtime - (JistAPI.getTime() - stime - totalPauseTime);
    }
   
    /** 
     * Pause timer
     */
    public void pause()
    {
        assert(started && !canceled && !paused);
        paused = true;
        lastMomentOfPause = JistAPI.getTime();
    }
    
    /** 
     * Resume timer
     */
    public void resume()
    {
        assert(started && !canceled);
        totalPauseTime += JistAPI.getTime() - lastMomentOfPause;
        paused = false;
        // sleep for the remaining amount of time in the timer
        JistAPI.sleep((long)(expire() * Constants.SECOND));
        if (!canceled && !paused)
        {
            self.timeout();
        }            
    }
    
    public void stopTimerr()
    {
         cancel();
	 resetTimer();
    }
}
