/*
 * macBackoffTimer.java
 *
 * Created on July 17, 2008, 11:44 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.stack.mac.ieee802_15_4;

import jist.runtime.JistAPI;
import jist.swans.Constants;
import sidnet.core.misc.TimerInterface;

/**
 *
 * @author Oliver
 * Java adaptation after NS-2 C++ implementation
 */
/*
 * Copyright (c) 2003-2004 Samsung Advanced Institute of Technology and
 * The City University of New York. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Joint Lab of Samsung 
 *      Advanced Institute of Technology and The City University of New York.
 * 4. Neither the name of Samsung Advanced Institute of Technology nor of 
 *    The City University of New York may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE JOINT LAB OF SAMSUNG ADVANCED INSTITUTE
 * OF TECHNOLOGY AND THE CITY UNIVERSITY OF NEW YORK ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN 
 * NO EVENT SHALL SAMSUNG ADVANCED INSTITUTE OR THE CITY UNIVERSITY OF NEW YORK 
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
public class macBackoffTimer implements TimerInterface
{
    protected boolean started;
    protected boolean busy;
    protected boolean paused;
    protected boolean canceled;
    protected double stime = 0.0;		//start time
    protected double wtime = 0.0;		//waiting time
    protected double lastMomentOfPause = 0.0;
    protected double totalPauseTime = 0.0;
    protected int id; // just for debugging
    
    // -------------------------------------
    private CsmaCA802_15_4 csmaca;
    
    protected double slottime;
    
    private TimerInterface self = (TimerInterface)JistAPI.proxy(this, TimerInterface.class);

    public macBackoffTimer(CsmaCA802_15_4 csma, int id)
    {
        //super();
        csmaca = csma;
        this.id = id;
    }
    //void	start(double time, double st, boolean idle);
    public void	timeout()
    {
        if (Def.DEBUG802_15_4_timer)
            System.out.println("[" + JistAPI.getTime() + "][#" + id + "][macBackoffTimer.timeout()]");        
        
        resetTimer();
        csmaca.backoffHandler();
        
    }
    // -------------------------------------
    public void resetTimer()
    {
        busy       = false;
        paused     = false;       
        stime = 0.0;
        wtime = 0.0;
    }
    
   
    /**
     * Start timer
     */
    public void startTimer(double time, double st, boolean idle)
    {
        wtime = time;
	slottime = st;

	if(idle == false)
		paused = true;
	else
		//Mac802_15_4Timer::start(wtime);
            startTimer(wtime);
    }
    
    public void startTimer(double time)
    {
        assert(!busy);
	busy = true;
        paused = false;
	stime = JistAPI.getTime();
	wtime = time;
	assert(wtime >= 0.0);
	//s.schedule(this, /* & */event, wtime);
        
        if (Def.DEBUG802_15_4_timer)
        {
            System.out.println("wtime = " + wtime);
            System.out.println("Constants.SECOND = " + Constants.SECOND);
            System.out.println("wtime * Constants.SECOND = " + (wtime * Constants.SECOND));
            System.out.println("[" + JistAPI.getTime() + "][#" + id + "][macBackoffTimer.startTimer()]. Timer scheduled to expire at " + (JistAPI.getTime() + wtime * Constants.SECOND) + " (wtime = " + wtime);
        }
        JistAPI.sleep((long)(wtime * Constants.SECOND));
        if (!canceled && !paused)
        {
            self.timeout();
        }
        else
            if (Def.DEBUG802_15_4_timer || Def. DEBUG802_15_4)
                System.out.println("[" + JistAPI.getTime() + "][#" + id + "][macBackoffTimer.startTimer()]. Timer has been cancelled or paused (cancelled = " + canceled + ", paused = " + paused);
        
    }
    
    /**
     * Cancel timer
     */ 
    public void cancel()
    {
        assert(started);
        canceled = true;
    }
    
    private boolean canceled()
    {
        return canceled;
    }
    
    public boolean busy()
    {
        return busy;
    }
    
    public boolean paused()
    {
        return paused;
    }
    
    public double expire()
    {
        return ((double)JistAPI.getTime())/Constants.SECOND - stime - totalPauseTime > wtime ? 0 : wtime - (JistAPI.getTime() - stime - totalPauseTime);
    }
   
    /** 
     * Pause timer
     */
    public void pause()
    {
        assert(started && !canceled && !paused);
        paused = true;
        lastMomentOfPause = JistAPI.getTime();
    }
    
    /** 
     * Resume timer
     */
    public void resume()
    {
        assert(started && !canceled);
        totalPauseTime += JistAPI.getTime() - lastMomentOfPause;
        paused = false;
        // sleep for the remaining amount of time in the timer
        JistAPI.sleepBlock((long)(expire() * Constants.SECOND));
        if (!canceled && !paused)
        {
            self.timeout();
        }            
    }
    
    public void stopTimerr()
    {
        assert(busy);
        if (!paused)
            cancel();
	resetTimer();
    }   
}
