/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sidnet.utilityviews.statscollector;

import sidnet.core.misc.Node;

/**
 *
 * @author Oliver
 */
public class StatEntry_AliveNodesCount extends StatEntry{
    private int aliveNodesCount = 0;
    private int energyPercentageThreshold;

    public StatEntry_AliveNodesCount(int energyPercentageThreshold) {
        this("AliveNodesCount", energyPercentageThreshold); // default header
    }

    public StatEntry_AliveNodesCount(String customHeader, int energyPercentageThreshold)
    {
        super(customHeader);
        this.energyPercentageThreshold = energyPercentageThreshold;
    }
            
    
    /**
     * @inheridoc
     */
    public String getValueAsString()
    {
        return "" + aliveNodesCount;
    }
    
    /**
     * @inheridoc
     */
   public void update(Node[] nodes)
   {
       aliveNodesCount = 0;
       for (int i = 0; i < nodes.length; i++)
       {
           if (nodes[i].getEnergyManagement().getBattery().getPercentageEnergyLevel() >= energyPercentageThreshold)
               aliveNodesCount++;
       }
   }

}
