/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sidnet.utilityviews.statscollector;

import sidnet.core.misc.Node;

/**
 *
 * @author Oliver
 */
public class StatEntry_DeadNodesCount extends StatEntry{
    private int deadNodesCount = 0;
    private int energyPercentageThreshold;

    public StatEntry_DeadNodesCount(int energyPercentageThreshold) {
        this("DeadNodesCount", energyPercentageThreshold); // default header
    }

    public StatEntry_DeadNodesCount(String customHeader, int energyPercentageThreshold)
    {
        super(customHeader);
        this.energyPercentageThreshold = energyPercentageThreshold;
    }
            
    
    /**
     * @inheridoc
     */
    public String getValueAsString()
    {
        return "" + deadNodesCount;
    }
    
    /**
     * @inheridoc
     */
   public void update(Node[] nodes)
   {
       deadNodesCount = 0;
       for (int i = 0; i < nodes.length; i++)
       {
           if (nodes[i].getEnergyManagement().getBattery().getPercentageEnergyLevel() < energyPercentageThreshold)
               deadNodesCount++;
       }
   }

}
