/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sidnet.utilityviews.statscollector;

import sidnet.core.misc.Node;

/**
 *
 * @author Oliver
 */
public class StatEntry_DeadNodesPercentage extends StatEntry{
    private double deadNodesPercentage = 0;
    private int energyPercentageThreshold;
         
    public StatEntry_DeadNodesPercentage(int energyPercentageThreshold) {
        this("DeadNodesPercentage", energyPercentageThreshold);
    }
    
    public StatEntry_DeadNodesPercentage(String customHeader, int energyPercentageThreshold) {
        super("DeadNodesPercengage");
        this.energyPercentageThreshold = energyPercentageThreshold;
    }
        
    /**
     * @inheridoc
     */
    public String getValueAsString()
    {
        return "" + deadNodesPercentage;
    }
    
    /**
     * @inheridoc
     */
   public void update(Node[] nodes)
   {
       int deadNodesCount = 0;
       for (int i = 0; i < nodes.length; i++)
       {
           if (nodes[i].getEnergyManagement().getBattery().getPercentageEnergyLevel() < energyPercentageThreshold)
               deadNodesCount++;
       }
       deadNodesPercentage = deadNodesCount / nodes.length * 100;
   }

}
