/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sidnet.utilityviews.statscollector;

import sidnet.core.misc.Node;

/**
 *
 * @author Oliver
 */
public class StatEntry_MinimumEnergyLeftPercentage extends StatEntry{
    private double minimumEnergyLeftPercentage = 0;

    public StatEntry_MinimumEnergyLeftPercentage() {
        this("MinimumEnergyLeftPercentage"); // default header
    }

    public StatEntry_MinimumEnergyLeftPercentage(String customHeader)
    {
        super(customHeader);
    }
            
    
    /**
     * @inheridoc
     */
    public String getValueAsString()
    {
        return "" + minimumEnergyLeftPercentage;
    }
    
    /**
     * @inheridoc
     */
   public void update(Node[] nodes)
   {
       minimumEnergyLeftPercentage = 100;
       for (int i = 0; i < nodes.length; i++)
           if (nodes[i].getEnergyManagement().getBattery().getPercentageEnergyLevel() < minimumEnergyLeftPercentage)
                minimumEnergyLeftPercentage = nodes[i].getEnergyManagement().getBattery().getPercentageEnergyLevel();
   }

}
