/*
 * MinimumEnergyLeftPercentageWithinRegion.java
 *
 * Created on June 1, 2008, 9:02 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package sidnet.utilityviews.statscollector;

import sidnet.utilityviews.statscollector.StatEntry;
import sidnet.core.misc.Node;
import sidnet.core.misc.Region;

/**
 *
 * @author Oliver
 */
public class StatEntry_MinimumEnergyLeftPercentageWithinRegion extends StatEntry
{
    private int minimumEnergyLeftPercentage;
    private Region restrictionRegion;
    private boolean restrictToInside; // false means restrict  to outside
    /**
     * Creates a new instance of MinimumEnergyLeftPercentageWithinRegion
     */
    public StatEntry_MinimumEnergyLeftPercentageWithinRegion(String header, Region restrictionRegion, boolean restrictToInside)
    {
        super(header);
        this.minimumEnergyLeftPercentage = 100;
        this.restrictionRegion = restrictionRegion;
        this.restrictToInside = restrictToInside;
    }
    
     public void evaluateBasedOnNode(Node node)
     {
         if (restrictToInside && restrictionRegion.isInside(node.getNCS_Location2D()) ||
             !restrictToInside && !restrictionRegion.isInside(node.getNCS_Location2D()))
         {
            if (minimumEnergyLeftPercentage > node.getEnergyManagement().getBattery().getPercentageEnergyLevel())
                minimumEnergyLeftPercentage = (int)node.getEnergyManagement().getBattery().getPercentageEnergyLevel();
         }
     }
     
    public String getValueAsString()
    {
        return "" + minimumEnergyLeftPercentage;
    } 
    
}
