#!/usr/bin/env python

import os, struct, re, time, os, signal

from optparse import OptionParser
from gnuradio import gr, blks2, audio
from gnuradio import eng_notation
from gnuradio.eng_option import eng_option

from AudioFrontend import AudioReceiver, AudioSource

from PacketTransceiver import PacketReceiver

class TopBlockReceiver(gr.top_block):
    def __init__(self, inputfile, callback, options):
        gr.top_block.__init__(self)

        # settings for the demodulator: /usr/local/lib/python2.5/site-packages/gnuradio/blks2impl/gmsk.py
        # settings for the demodulator: /usr/local/lib/python2.5/site-packages/gnuradio/blks2impl/pkt.py

        self.audioSource = AudioSource(options, inputfile)
        self.audioRxFe = AudioReceiver(options)
        #self.demodulator = blks2.gmsk_demod(samples_per_symbol=options.samples_per_symbol)
        self.demodulator = blks2.dbpsk_demod(samples_per_symbol=options.samples_per_symbol)
        self.pkt_queue   = blks2.demod_pkts( demodulator=self.demodulator, callback=callback, threshold=options.threshold )

        self.connect(self.audioSource, self.audioRxFe, self.pkt_queue)


def main(inputfile, options):
    receiver = PacketReceiver(options)
    tb = TopBlockReceiver(inputfile, receiver.rx, options)
    tb.run()

if __name__ == '__main__':
    usage="%prog: [options] inputfile"
    parser = OptionParser(usage, option_class=eng_option, conflict_handler="resolve")

    parser.add_option("-q", "--quiet", action="store_false", dest="verbose", default=False, help="quiet? [default: False]")
    parser.add_option("-v", "--verbose", action="store_true", default=True, help="verbose? [default: %default]")
    parser.add_option("-z", "--samples-per-symbol", type="int", default=32, help="samples per symbol [default=%default]")
    parser.add_option("-t", "--threshold", type="int", default=12, help="detect frame header with up to threshold bits wrong [default=%default]")
    PacketReceiver.add_options(parser)

    rxfe_grp = parser.add_option_group("Audio Receiver Frontend")
    AudioReceiver.add_options(rxfe_grp)
    as_grp = parser.add_option_group("Audio Source")
    AudioSource.add_options(as_grp)

    (options, args) = parser.parse_args()

    inputfile = None
    if not options.dsp:
        if len(args) != 1:
            parser.print_help()
            raise SystemExit, "ERROR: one argument required"

        inputfile = args[0]

        if not os.path.exists(inputfile):
            parser.print_help()
            raise SystemExit, "ERROR: input file must exist"

    try:
        main(inputfile, options)

    except KeyboardInterrupt:
        pass
