#!/usr/bin/env python

import os, struct, math

from optparse import OptionParser
from gnuradio import gr, blks2, audio
from gnuradio import eng_notation
from gnuradio.eng_option import eng_option

from gnuradio.gr import firdes

from AudioFrontend import AudioTransmitter, AudioSink, AudioReceiver
from PacketTransceiver import PacketSender, PacketReceiver

class TopBlockSender(gr.top_block):
    def __init__(self, outputfile, options):
        gr.top_block.__init__(self)

        # settings for the modulator: /usr/local/lib/python2.5/site-packages/gnuradio/blks2impl/gmsk.py

        #self.modulator = blks2.gmsk_mod(samples_per_symbol=options.samples_per_symbol)
        self.modulator = blks2.dbpsk_mod(samples_per_symbol=options.samples_per_symbol)
        self.pkt_queue = blks2.mod_pkts( modulator=self.modulator )
        self.audioTxFe = AudioTransmitter(options)
        self.audioSink = AudioSink(options, outputfile)

        self.connect(self.pkt_queue, self.audioTxFe)
        self.connect(self.audioTxFe, self.audioSink)

    def send_pkt(self, msg=""):
        self.pkt_queue.send_pkt(msg)

    def eof(self):
        self.send_pkt()
        self.pkt_queue.send_pkt(eof=True)

    def main():
        usage="%prog: [options] inputfile [outputfile|--dsp]"
        parser = OptionParser(usage, option_class=eng_option, conflict_handler="resolve")

        parser.add_option("-q", "--quiet", action="store_false", dest="verbose", default=False, help="quiet? [default: False]")
        parser.add_option("-v", "--verbose", action="store_true", default=True, help="verbose? [default: %default]")
        PacketSender.add_options(parser)
        txfe_grp = parser.add_option_group("Audio Transmitter Frontend")
        AudioTransmitter.add_options(txfe_grp)
        as_grp = parser.add_option_group("Audio Sink")
        AudioSink.add_options(as_grp)
        (options, args) = parser.parse_args()

        outputfile = "n/a"
        if options.dsp:
            if len(args) != 1:
                parser.print_help()
                raise SystemExit, "ERROR: one argument required"
        else:
            if len(args) != 2:
                parser.print_help()
                raise SystemExit, "ERROR: two arguments required"
            outputfile = args[1]

        inputfile = args[0]

        if not os.path.exists(inputfile):
            parser.print_help()
            raise SystemExit, "ERROR: input file must exist"

        try:
            tb = TopBlockSender(outputfile, options)
            tb.start()

            ps = PacketSender(tb, options)
            ps.run(inputfile)

            tb.eof()
            tb.wait()

        except KeyboardInterrupt:
            pass

    # Make a static method to call before instantiation
    main = staticmethod(main)


if __name__ == '__main__':
    TopBlockSender.main()
