#!/usr/bin/env python

import os, struct, re, time, os, signal

from gnuradio import gr, blks2, audio
from optparse import OptionParser
from gnuradio import eng_notation
from gnuradio.eng_option import eng_option

class debugwav(gr.hier_block2):
    def __init__(self, name, options):
        gr.hier_block2.__init__( self, "debugger: " + name,
            gr.io_signature(1, 1, gr.sizeof_gr_complex), # input signature
            gr.io_signature(0, 0, 0*0), # output signature
        )

        fname = "debug_" + name + ".wav"

        self.c_to_iq = gr.complex_to_float()
        self.wavdump = gr.wavfile_sink(fname, 2, options.wav_sample_rate, 16)

        if options.verbose: print "writing a complex stream to file: %s" % fname

        self.connect( self, self.c_to_iq )
        self.connect( (self.c_to_iq, 0), (self.wavdump, 0))
        self.connect( (self.c_to_iq, 1), (self.wavdump, 1))

class TopBlockDump(gr.top_block):
    def __init__(self, outputfile, options):
        gr.top_block.__init__(self)

        self.src = audio.source(options.dsp_sample_rate, "", True)
        self.wavdump = gr.wavfile_sink(outputfile, 2, options.wav_sample_rate, 16)
        #self.deb = debugwav(outputfile, options)

        #self.iq_to_c = gr.float_to_complex()
        #self.connect( (self.src, 0), (self.iq_to_c, 0) )
        #self.connect( (self.src, 1), (self.iq_to_c, 1) )
        #self.connect(self.iq_to_c, self.deb)
        self.connect((self.src,0), (self.wavdump,0));
        self.connect((self.src,1), (self.wavdump,1));

if __name__ == '__main__':
    usage="%prog: [options] inputfile"
    parser = OptionParser(usage, option_class=eng_option, conflict_handler="resolve")
    parser.add_option("-r", "--dsp-sample-rate", type="int", default=48000, help="soundcard sample rate [default: %default Hz]")
    parser.add_option("-w", "--wav-sample-rate", type="int", default=48000, help="wav-file sample rate [default: %default Hz]")
    parser.add_option("-v", "--verbose", action="store_true", default=True, help="verbose? [default: %default]")
    (options, args) = parser.parse_args()

    inputfile = None
    if len(args) != 1:
        parser.print_help()
        raise SystemExit, "ERROR: one argument required"
    inputfile = args[0]

    try:
        tb = TopBlockDump(inputfile, options)
        tb.run()

    except KeyboardInterrupt:
        pass

