#!/bin/sh
# disable filename globbing
set -f

TEMP=/tmp/XXXXX$$
TEMP1=/tmp/YYYYY$$
TEMP2=/tmp/ZZZZZZ$$
SUBMIT=/var/submit
SLEEP=0


/usr/bin/echo $REMOTE_ADDR >>/tmp/logpass
sendmsg() {
    if [ $SLEEP -ne 0 ] ; then
       sleep $SLEEP
    fi
    /usr/bin/echo "Content-type: text/html\n"
    /usr/bin/echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'
    /usr/bin/cat /var/apache2/htdocs/head.html
    /usr/bin/cat <<ERROR
        <TITLE>&Auml;ndern des Domain-Passwortes</TITLE>
        <H1> &Auml;ndern des Domain-Passwortes</H1>
        <body> 
            <hr size=1>
            <br>
              <H3>$MESSAGE </H3>
            <br>
             <hr size=1>
             <font size=4><A href="https://base3.informatik.hu-berlin.de/pass.shtml">zur&uuml;ck zum &Auml;ndern des Domain-Passwortes</A> </font>
ERROR
    /usr/bin/cat /var/apache2/htdocs/end.html
}

convert() {
    /usr/bin/echo "$CONVSTRI" | /opt/csw/bin/gsed \
    -e "s/+/ /g"   \
    -e "s/%21/!/g" \
    -e 's/%22/"/g' \
    -e "s/%23/#/g" \
    -e 's/%24/$/g' \
    -e "s/%25/%/g" \
    -e "s/%26/\&/" \
    -e "s/%27/'/g" \
    -e "s/%28/(/g" \
    -e "s/%29/)/g" \
    -e "s/%2B/+/g" \
    -e "s/%2C/,/g" \
    -e "s.%2F./.g" \
    -e "s/%3A/:/g" \
    -e "s/%3B/;/g" \
    -e "s/%3C/</g" \
    -e "s/%3D/=/g" \
    -e "s/%3E/>/g" \
    -e "s/%3F/?/g" \
    -e "s/%40/@/g" \
    -e "s/%5B/[/g" \
    -e 's/%5C/\\/g' \
    -e "s/%5D/]/g" \
    -e "s/%5E/^/g" \
    -e "s/%60/\`/g" \
    -e "s/%7B/{/g" \
    -e "s/%7C/|/g" \
    -e "s/%7D/}/g" \
    -e "s/%7E/~/g" \
    -e "s/%B0//g" \
    -e "s/%DF//g" \
    -e "s/%E4//g" \
    -e "s/%F6//g" \
    -e "s/%FC//g" \
    -e "s/%C4//g" \
    -e "s/%D6//g" \
    -e "s/%DC//g" \
    -e "s/%A7//g"  > $TEMP2
    CONVSTR="`/usr/bin/cat $TEMP2`"
    rm $TEMP2
}


if [ "X$REQUEST_METHOD" != "XPOST" ] ; then
    /usr/bin/echo "Content-type: text/html\n"
    /usr/bin/echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'
    /usr/bin/cat <<EOF
<html>
        <head>
        <meta http-equiv="refresh" content="0; URL=http://www2.informatik.hu-berlin.de/">
        </head>
        <body></body>
        </html>
EOF
    exit 1
fi

/usr/bin/cat  >$TEMP

CONVSTRI="`/usr/bin/awk '-F&' '{ split($1,F,"="); print F[2]; }' $TEMP`"
convert
SUBDOMAIN="$CONVSTRI"
CONVSTRI="`/usr/bin/awk '-F&' '{ split($2,F,"="); print F[2]; }' $TEMP`"
convert
W1="$CONVSTR"
/usr/bin/awk '-F&' '{ split($3,F,"="); printf("%s",F[2]); }' $TEMP > $TEMP1
CONVSTRI="`/usr/bin/cat $TEMP1`"
convert
W2="$CONVSTR"
/bin/echo "$W2\c" > $TEMP1
chmod og-rwx $TEMP1
CONVSTRI="`/usr/bin/awk '-F&' '{ split($4,F,"="); print F[2]; }' $TEMP`"
convert
W3="$CONVSTR"
CONVSTRI="`/usr/bin/awk '-F&' '{ split($5,F,"="); print F[2]; }' $TEMP`"
convert
W4="$CONVSTR"
#
# Pruefen ob alle Felder ausgefuellt sind
#
if [ "x$W1" = "x" -o "x$W3" = "x" -o "x$W4" = "x" -o ! -s $TEMP1 ] ; then
    MESSAGE="Fehler: Ein Feld wurde nicht ausgef&uuml;llt."
    /usr/bin/rm -f $TEMP1
    /usr/bin/rm -f $TEMP
    sendmsg
    exit
fi
#
#  Zugriffsberechtigung pruefen
#
/opt/csw/bin/ldapsearch -x -D uid=$W1,ou=People,ou=$SUBDOMAIN,dc=informatik,dc=hu-berlin,dc=de -y $TEMP1 -b ou=People,ou=$SUBDOMAIN,dc=informatik,dc=hu-berlin,dc=de uid=$W1  uid userPassword 2>/dev/null | /opt/csw/bin/gawk '/^uid:/{ print $2; } /^userPassword::/{ print $2; }' >$TEMP 2>/dev/null
R1="`/usr/bin/head -1 $TEMP`"
R2="`/usr/bin/tail -1 $TEMP`"
RECORDS=`/usr/bin/wc -l $TEMP | /usr/bin/awk '{ print $1 }`
if [ $RECORDS -ne 2 ] ; then
    MESSAGE="Fehler: Bitte beim Accountmanager melden"
    sendmsg
    exit
fi
/usr/bin/rm -f $TEMP1
/usr/bin/rm -f $TEMP
if [ "x$R1" != "x$W1" -o "x$R2" = "x" ] ; then
   SLEEP=5
   MESSAGE="Fehler: Nutzeridentifikation fehlgeschlagen - falscher Nutzer oder falsche Passwort"
   sendmsg
   exit
fi
if [ "x$W3" != "x$W4" ] ; then
    MESSAGE="Fehler: Eingabe des neuen Passwortes falsch, Eingaben nicht identisch)."
    sendmsg
    exit
fi
# if [ "x$W2" = "x$W3" ] ; then
#     MESSAGE="Fehler: Eingabe des neuen Passwortes falsch, neues Passwort ist identisch mit dem alten Passwort."
#     sendmsg
#     exit
# fi
/opt/csw/bin/gawk '{ if ( $1 ~ "[a-zA-Z]" )  RET=1;  \
                     if ( $1 ~ "[0-9]"    )  RET=RET+1; \
                     if  ($1 ~ "[^0-9a-zA-Z\n]" ) RET=RET+1;   \
                     if  ( length($1) >= 8 )      RET=RET+1; } \
                   END { exit (RET) } ' <<EOF
$W3
EOF
RES=$?
if [ $RES != 4 ] ; then
    MESSAGE="Fehler: Eingegebenes neues Passwort zu einfach!!<br>        Mindestens 8 Zeichen, mit Buchstaben, Ziffern und Sonderzeichen"
    sendmsg
    exit
fi
# echo Content-type: text/plain
# echo
MESSAGE="Passwort f&uuml;r Nutzer '$W1' zur &Auml;nderung vorgemerkt. <br> &Auml;nderung erfolgt sp&auml;testens zur n&auml;chsten vollen Stunde."
sendmsg
/usr/bin/cat <<EOF  | /opt/csw/bin/gpg -r ldaps -e >$SUBMIT/$W1.gpg 2>/dev/null
$W1 $SUBDOMAIN $W1 $W3 $R2
EOF
chmod og-rwx $SUBMIT/$W1.gpg
exit
